﻿/*global angular, jQuery*/
(function ($) {
    angular
        .module('simplAdmin.catalog')
        .controller('CategoriesWidgetFormCtrl', ['$state', '$stateParams', 'categoriesWidgetService', 'translateService', CategoriesWidgetFormCtrl]);

    function CategoriesWidgetFormCtrl($state, $stateParams, categoriesWidgetService , translateService) {
        var vm = this;
        vm.translate = translateService;
        vm.widgetZones = [];
        vm.categories = [];
        vm.widgetInstance = { widgetZoneId: 1, settings: { numberOfCategory: 1 }, publishStart: new Date() };
        vm.widgetInstanceId = $stateParams.id;
        vm.isEditMode = vm.widgetInstanceId > 0;
        vm.numberOfWidgets = [];

        vm.datePickerPublishStart = {};
        vm.datePickerPublishEnd = {};

        vm.openCalendar = function (e, picker) {
            vm[picker].open = true;
        };

        vm.save = function save() {
            var promise;
            if (vm.isEditMode) {
                promise = categoriesWidgetService.editCategoriesWidget(vm.widgetInstance);
            } else {
                promise = categoriesWidgetService.createCategoriesWidget(vm.widgetInstance);
            }

            promise
                .then(function (result) {
                    $state.go('widget');
                })
                .catch(function (response) {
                    var error = response.data;
                    vm.validationErrors = [];
                    if (error && angular.isObject(error)) {
                        for (var key in error) {
                            vm.validationErrors.push(error[key][0]);
                        }
                    } else {
                        vm.validationErrors.push('Could not product display widget.');
                    }
                });
        };

        function init() {
            categoriesWidgetService.getWidgetZones().then(function (result) {
                vm.widgetZones = result.data;
            });
            categoriesWidgetService.getCategories().then(function (result) {
                vm.categories = result.data;
            });

            categoriesWidgetService.getNumberOfWidgets().then(function (result) {
                var count = parseInt(result.data);
                if (!vm.isEditMode) {
                    count = count + 1;
                }

                for (var i = 1; i <= count; i++)
                    vm.numberOfWidgets.push(i);
            });

            if (vm.isEditMode) {
                categoriesWidgetService.getCategoriesWidget(vm.widgetInstanceId).then(function (result) {
                    vm.widgetInstance = result.data;
                    if (vm.widgetInstance.publishStart) {
                        vm.widgetInstance.publishStart = new Date(vm.widgetInstance.publishStart);
                    }
                    if (vm.widgetInstance.publishEnd) {
                        vm.widgetInstance.publishEnd = new Date(vm.widgetInstance.publishEnd);
                    }
                });
            }
        }

        init();
    }
})(jQuery);
