﻿/*global angular*/
(function () {
    angular
        .module('simplAdmin.catalog')
        .factory('categoriesWidgetService', ['$http', categoriesWidgetService]);

    function categoriesWidgetService($http) {
        var service = {
            getWidgetZones: getWidgetZones,
            getCategories: getCategories,
            getCategoriesWidget: getCategoriesWidget,
            createCategoriesWidget: createCategoriesWidget,
            editCategoriesWidget: editCategoriesWidget,
            getNumberOfWidgets: getNumberOfWidgets
        };
        return service;

        function getWidgetZones() {
            return $http.get('api/widget-zones');
        }

        function getCategoriesWidget(id) {
            return $http.get('api/categories-widgets/' + id);
        }

        function createCategoriesWidget(widgetInstance) {
            return $http.post('api/categories-widgets', widgetInstance);
        }

        function editCategoriesWidget(widgetInstance) {
            return $http.put('api/categories-widgets/' + widgetInstance.id, widgetInstance);
        }

        function getCategories() {
            return $http.get('api/categories');
        }

        function getNumberOfWidgets() {
            return $http.get('api/widget-instances/number-of-widgets');
        }
    }
})();
