﻿/*global angular*/
(function () {
    angular
        .module('simplAdmin.core')
        .factory('unitService', ['$http', unitService]);

    function unitService($http) {
        var service = {
            getUnits: getUnits,
            getAllUnits: getAllUnits,
            editUnit: editUnit,
            getUnit: getUnit,
            createUnit: createUnit,
            deleteUnit: deleteUnit
        };
        return service;

        function getUnits(params) {
            return $http.post('api/units/grid', params);
        }

        function getAllUnits() {
            return $http.get('api/units');
        }

        function getUnit(id) {
            return $http.get('api/units/' + id, null);
        }

        function editUnit(unit) {
            return $http.put('api/units/' + unit.id, unit);
        }

        function createUnit(unit) {
            return $http.post('api/units/', unit);
        }

        function deleteUnit(unit) {
            return $http.delete('api/units/' + unit.id, null);
        }
    }
})();
