﻿/*global angular*/
(function () {
    toastr.options.closeButton = true;
    toastr.options.escapeHtml = true;
    angular.module('simplAdmin')
        .factory('httpResponseInterceptor', ['$q', '$rootScope', '$location', function ($q, $rootScope, $location) {
            return {
                responseError: function (rejection) {
                    if (rejection.status === 401) {
                        // Something like below:
                        window.location.href = '/login';
                    }
                    return $q.reject(rejection);
                }
            };
        }])
        .config([
            '$urlRouterProvider', '$httpProvider',
            function ($urlRouterProvider, $httpProvider) {
                $urlRouterProvider.otherwise("/dashboard");

                $httpProvider.interceptors.push(function () {
                    return {
                        request: function (config) {
                            if (/modules.*admin.*\.html/i.test(config.url)) {
                                var separator = config.url.indexOf('?') === -1 ? '?' : '&';
                                config.url = config.url + separator + 'v=' + window.Global_AssetVersion;
                            }

                            return config;
                        }
                    };
                });

                $httpProvider.interceptors.push('httpResponseInterceptor');
            }
        ]);
}());
