﻿/*global angular*/
(function () {
    angular
        .module('simplAdmin.core')
        .factory('roleService', ['$http', roleService]);

    function roleService($http) {
        var service = {
            getRoles: getRoles,
            getAllRoles: getAllRoles,
            editRole: editRole,
            getRole: getRole,
            createRole: createRole,
            deleteRole: deleteRole
        };
        return service;

        function getRoles(params) {
            return $http.post('api/roles/grid', params);
        }

        function getAllRoles() {
            return $http.get('api/roles');
        }

        function getRole(id) {
            return $http.get('api/roles/' + id, null);
        }

        function editRole(role) {
            return $http.put('api/roles/' + role.id, role);
        }

        function createRole(role) {
            return $http.post('api/roles/', role);
        }

        function deleteRole(role) {
            return $http.delete('api/roles/' + role.id, null);
        }
    }
})();
