﻿(function() {
    angular
        .module('simplAdmin.orders')
        .directive('customerCountWidget', customerCountWidget);

    function customerCountWidget() {
        var directive = {
            restrict: 'E',
            templateUrl: '_content/TTS.Module.Orders/admin/customer/customer-count-widget.directive.html',
            scope: {
                status: '=',
                numRecords: '='
            },
            controller: ['customerService', 'translateService', customerCountWidgetCtrl],
            controllerAs: 'vm',
            bindToController: true
        };

        return directive;
    }

    function customerCountWidgetCtrl(customerService, translateService) {
        var vm = this;
        vm.translate = translateService;
        vm.customers = [];

        vm.$onInit = function () {
            customerService.getCustomerSummary().then(function (result) {
                vm.customers = result.data;
            });
        };
    }
})();
