﻿ /*global angular*/
(function () {
    angular
        .module('simplAdmin.orders')
        .controller('CustomerFormCtrl', ['$state', '$stateParams', 'customerService', 'translateService', CustomerFormCtrl]);

    function CustomerFormCtrl($state, $stateParams, customerService, translateService) {
        var vm = this;
        vm.translate = translateService;
        vm.customer = { roleIds: [], customerGroupIds: [] };
        vm.vendors = [];
        vm.roles = [];
        vm.customerGroups = [];
        vm.customerId = $stateParams.id;
        vm.isEditMode = vm.customerId > 0;

        vm.toggleRoles = function toggleRoles(roleId) {
            var index = vm.customer.roleIds.indexOf(roleId);
            if (index > -1) {
                vm.customer.roleIds.splice(index, 1);
            } else {
                vm.customer.roleIds.push(roleId);
            }
        };

        vm.toggleCustomerGroups = function toggleCustomerGroups(customergroupId) {
            var index = vm.customer.customerGroupIds.indexOf(customergroupId);
            if (index > -1) {
                vm.customer.customerGroupIds.splice(index, 1);
            } else {
                vm.customer.customerGroupIds.push(customergroupId);
            }
        };

        vm.save = function save() {
            if (!vm.customer.email || vm.customer.email === "") {
                vm.customer.email = 'customer@tts.com';
            }

            var promise;            
            if (vm.isEditMode) {
                promise = customerService.editCustomer(vm.customer);
            } else {
                promise = customerService.createCustomer(vm.customer);
            }

            promise
                .then(function (result) {
                    $state.go('customers');
                })
                .catch(function (response) {
                    var error = response.data;
                    vm.validationErrors = [];
                    if (error && angular.isObject(error)) {
                        for (var key in error) {
                            vm.validationErrors.push(error[key][0]);
                        }
                    } else {
                        vm.validationErrors.push('Could not add customer.');
                    }
                });
        };

        function getVendors() {
            customerService.getVendors().then(function (result) {
                vm.vendors = result.data;
            });
        }

        function getRoles() {
            customerService.getRoles().then(function (result) {
                vm.roles = result.data;
            });
        }

        function getCustomerGroups() {
            customerService.getCustomerGroups().then(function (result) {
                vm.customerGroups = result.data;
            });
        }

        function init() {
            if (vm.isEditMode) {
                customerService.getCustomer(vm.customerId).then(function (result) {
                    vm.customer = result.data;
                });
            }

            //getVendors();
            getRoles();
            getCustomerGroups();
        }

        init();
    }
})();
