﻿/*global angular*/
(function () {
    angular
        .module('simplAdmin.orders')
        .controller('CustomerListCtrl', ['customerService', 'translateService', CustomerListCtrl]);

    function CustomerListCtrl(customerService, translateService) {
        var vm = this;
        vm.tableStateRef = {};
        vm.customers = [];
        vm.roles = [];
        vm.customerGroups = [];
        vm.translate = translateService;

        vm.getCustomers = function getCustomers(tableState) {
            vm.tableStateRef = tableState;
            vm.isLoading = true;
            customerService.getCustomers(tableState).then(function (result) {
                vm.customers = result.data.items;
                tableState.pagination.totalItemCount = result.data.totalRecord;
                tableState.pagination.numberOfPages = result.data.numberOfPages;
                vm.isLoading = false;
            });
        };

        vm.deleteCustomer = function deleteCustomer(customer) {
            bootbox.confirm('Are you sure you want to delete this customer: ' + simplUtil.escapeHtml(customer.fullName), function (result) {
                if (result) {
                    customerService.deleteCustomer(customer)
                        .then(function (result) {
                            vm.getCustomers(vm.tableStateRef);
                            toastr.success(customer.fullName + ' has been deleted');
                        })
                        .catch(function (response) {
                            toastr.error(response.data.error);
                        });
                }
            });
        };

        function init() {
            //customerService.getRoles().then(function (result) {
            //    vm.roles = result.data;
            //});

            customerService.getCustomerGroups().then(function (result) {
                vm.getCustomerGroups = result.data;
            });
        }

        init();
    }
})();
