﻿/*global angular*/
(function () {
    angular
        .module('simplAdmin.orders')
        .factory('customerService', ['$http', customerService]);

    function customerService($http) {
        var service = {
            getCustomers: getCustomers,
            getCustomer: getCustomer,
            quickSearchCustomers: quickSearchCustomers,
            createCustomer: createCustomer,
            editCustomer: editCustomer,
            deleteCustomer: deleteCustomer,
            getRoles: getRoles,
            getVendors: getVendors,
            getCustomerGroups: getCustomerGroups,
            getCustomerSummary: getCustomerSummary
        };
        return service;

        function getCustomers(params) {
            return $http.post('api/customers/grid', params);
        }

        function getCustomer(id) {
            return $http.get('api/customers/' + id);
        }

        function quickSearchCustomers(name) {
            return $http.get('api/customers/quick-search/?name=' + name);
        }

        function createCustomer(customer) {
            return $http.post('api/customers', customer);
        }

        function editCustomer(customer) {
            return $http.put('api/customers/' + customer.id, customer);
        }

        function deleteCustomer(customer) {
            return $http.delete('api/customers/' + customer.id, null);
        }

        function getRoles() {
            return $http.get('api/roles');
        }

        function getVendors() {
            return $http.get('api/vendors');
        }

        function getCustomerGroups() {
            return $http.get('api/customergroups');
        }

        function getCustomerSummary() {
            return $http.get('api/customers/summary');
        }

    }
})();
