﻿(function() {
    angular
        .module('simplAdmin.orders')
        .directive('orderCountWidget', orderCountWidget);

    function orderCountWidget() {
        var directive = {
            restrict: 'E',
            templateUrl: '_content/TTS.Module.Orders/admin/order/order-count-widget.directive.html',
            scope: {
                status: '=',
                numRecords: '='
            },
            controller: ['orderService', 'translateService', OrderCountWidgetCtrl],
            controllerAs: 'vm',
            bindToController: true
        };

        return directive;
    }

    function OrderCountWidgetCtrl(orderService, translateService) {
        var vm = this;
        vm.translate = translateService;
        vm.orders = [];

        vm.$onInit = function () {
            orderService.getOrderSummary().then(function (result) {
                vm.orders = result.data;
            });
        };
    }
})();
