﻿/*global angular*/
(function () {
    'use strict';

    angular
        .module('simplAdmin.orders', [])
        .config(['$stateProvider',
            function ($stateProvider) {
                $stateProvider
                    .state('order', {
                        url: '/order',
                        templateUrl: '_content/TTS.Module.Orders/admin/order/order-list.html',
                        controller: 'OrderListCtrl as vm'
                    })
                    .state('order-detail', {
                        url: '/order/detail/:id',
                        templateUrl: '_content/TTS.Module.Orders/admin/order/order-detail.html',
                        controller: 'OrderDetailCtrl as vm'
                    })
                    .state('order-create', {
                        url: '/order-create',
                        templateUrl: '_content/TTS.Module.Orders/admin/order/order-create.html',
                        controller: 'OrderCreateCtrl as vm'
                    })
                    .state('customers', {
                        url: '/customers',
                        templateUrl: '_content/TTS.Module.Orders/admin/customer/customer-list.html',
                        controller: 'CustomerListCtrl as vm'
                    })
                    .state('customer-create', {
                        url: '/customer-create',
                        templateUrl: '_content/TTS.Module.Orders/admin/customer/customer-form.html',
                        controller: 'CustomerFormCtrl as vm'
                    })
                    .state('customer-edit', {
                        url: '/customer-edit/:id',
                        templateUrl: '_content/TTS.Module.Orders/admin/customer/customer-form.html',
                        controller: 'CustomerFormCtrl as vm'
                    })
                ;
            }
        ]);
})();
