﻿(function() {
    angular
        .module('simpl.shoppingCart')
        .factory('shoppingCartService', [
            '$http',
            function ($http) {
                function getShoppingCartItems() {
                    return $http.get('pos/list');
                }
                
                function removeShoppingCartItem(itemId) {
                    return $http.post('pos/remove-item', itemId);
                }

                function updateQuantity(itemId, quantity) {
                    return $http.post('pos/update-item-quantity', {
                        cartItemId: itemId,
                        quantity: quantity
                    });
                }

                function applyCoupon(couponCode) {
                    return $http.post('pos/apply-coupon', { couponCode: couponCode });
                }

                function saveOrderNote(orderNote) {
                    return $http.post('pos/save-ordernote', { orderNote: orderNote });
                }

                function unlock() {
                    return $http.post('pos/unlock');
                }

                function quickSearchProducts(params) {
                    return $http.post('api/pos/products', params);
                }

                function quickCheckProduct(id) {
                    return $http.get('api/products/quick-check?id=' + id);
                }

                function getProduct(id) {
                    return $http.get('api/products/' + id);
                }

                function getProducts(params) {
                    return $http.post('api/pos/products', params);
                }

                //function addCartItem(cartItem) {
                //    return $http.post('pos/add-item', cartItem);
                //}

                function addCartItem(customerId, cartItem) {
                    return $http.post('api/customers/' + customerId + '/add-cart-item', cartItem);
                }

                function updateCartItem(cartItem) {
                    return $http.put('api/carts/items/' + cartItem.id, cartItem);
                }

                function removeCartItem(cartItemId) {
                    return $http.delete('api/carts/items/' + cartItemId);
                }

                function createOrder(cartId, orderInfo) {
                    return $http.post('api/pos/cart/' + cartId + '/order', orderInfo);
                }

                function quickSearchCustomers(name) {
                    return $http.get('api/customers/quick-search/?name=' + name);
                }

                function getCart(customerId) {
                    return $http.get('api/customers/' + customerId + '/cart');
                }

                function updateTaxAndShippingPrice(cartId, taxAndShippingPriceRequestVm) {
                    return $http.post('api/cart/' + cartId + '/update-tax-and-shipping-prices', taxAndShippingPriceRequestVm);
                }

                return {
                    getShoppingCartItems: getShoppingCartItems,
                    removeShoppingCartItem: removeShoppingCartItem,
                    updateQuantity: updateQuantity,
                    applyCoupon: applyCoupon,
                    saveOrderNote: saveOrderNote,
                    unlock: unlock,
                    quickSearchProducts: quickSearchProducts,
                    quickCheckProduct: quickCheckProduct,
                    getProduct: getProduct,
                    getProducts: getProducts,
                    addCartItem: addCartItem,
                    createOrder: createOrder,
                    quickSearchCustomers: quickSearchCustomers,
                    getCart: getCart,
                    updateTaxAndShippingPrice: updateTaxAndShippingPrice,
                    updateCartItem: updateCartItem,
                    removeCartItem: removeCartItem
                };
            }
        ]);
})();
