﻿/*global angular*/
(function () {
    angular
        .module('simplAdmin.wooCommerce')
        .factory('wooCommerceService', ['$http', wooCommerceService]);

    function wooCommerceService($http) {
        var service = {
            getProducts: getProducts,
            getProduct: getProduct,
            createProduct: createProduct,
            editProduct: editProduct,
            deleteProduct: deleteProduct
        };
        return service;

        function getProducts(params) {
            return $http.post('api/wooCommerce/grid', params);
        }

        function getProduct(id) {
            return $http.get('api/wooCommerce/' + id);
        }

        function createProduct(product) {
            return $http.post('api/wooCommerce/product', product);
        }

        function editProduct(product) {
            return $http.put('api/wooCommerce/' + product.id, product);
        }

        function deleteProduct(product) {
            return $http.delete('api/wooCommerce/' + product.id, null);
        }
    }
})();
